% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.layout.grid}
\alias{mcg.layout.grid}
\title{Grid layout}
\usage{
mcg.layout.grid(A, noise = FALSE, layout_matrix = NULL)
}
\arguments{
\item{A}{Adjacency matrix}

\item{noise}{Boolean. Should noise be added to the coordinates? Default: FALSE}

\item{layout_matrix}{Optional matrix indicating positions of variables set as strings. Default: NULL}
}
\value{
Two column matrix for x and y coordinates.
}
\description{
Layout nodes on a grid
}
\details{
By default, nodes are automatically positioned on the grid. For defining node positions manually, it is possible to provide
         a layout matrix with positions of the variables. The variable names in the fields of the matrix must correspond to the
         \code{dimnames} of the adjacency matrix. Empty space between the variables can be introduced by setting the according field to \code{NA}.
}
\examples{
# Network estimation
pred <- mcg.lvs(swiss)
# Automatically plotting nodes on a grid
plot(pred, vertex.symbol="rectangle", layout="grid", vertex.size=2.5, vertex.length=1.25)

# Define costume positional matrix
lmat <- rbind(c(NA, "Catholic", NA),
              c("Fertility", NA, "Education"),
              c("Infant.Mortality", NA, "Agriculture"),
              c(NA, "Examination", NA))
# Plotting based on costume grid layout
lay <- mcg.layout.grid(pred, layout_matrix=lmat)
plot(pred, vertex.symbol="rectangle", vertex.size=2.5, vertex.length=1.25, layout=lay)
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>, Masiar Novine <email: masiar.novine@gmail.com>
}
