% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.rpart}
\alias{mcg.rpart}
\title{mcg.rpart - create new graphs from data using regression trees}
\usage{
mcg.rpart(x, type = "rpart", rs = 0.04, k = 10, keep = "mcgraph")
}
\arguments{
\item{x}{data frame or matrix with numerical daattr(Gswiss,"r.squared"),3ta.}

\item{type}{custom type name for the graph, Default: 'rpart'}

\item{rs}{threshold for the R-square value. Default: 0.04}

\item{k}{maximal number of correlated variables to consider, default: 10}

\item{keep}{what data should be returned, either mcgraph or list
(adjacency list) or matrix (adjacency matrix), list might be useful for
for many columns, default: 'mcgraph'}
}
\value{
an mcgraph object for the data, or a adjacency matrix or list depending on the keep argument,
     in the djacency matrix a value of minus indicate negative associations
     between the nodes, a value of +1 positive associations.
}
\description{
The function mcg.rpart - creates a new mcgraph object from
       given data using regression trees. The algorithm will evaluate
       for every variable the ten variables with the highest absolute
       Spearman correlation for their predictive power. Variables which
       increase the predictive power, emasured using R-square by more than the threshold, default 0.2, will be connected with edges.
}
\examples{
 data(swiss)
 Gswiss=mcg.rpart(swiss,rs=0.1)
 plot(Gswiss,main="Predicted Graph",layout='sam')
}
\author{
Detlef Groth, University of Potsdam
}
