### SUPPLEMENTARY TABLES WITH MEDIANS OF BOXPLOTS ###

# # Check, if the user is already in 'results' folder, otherwise change folder
# # This will obviously not work, if the user is not at least in the parent folder
# if (length(grep(x=getwd(), pattern="results")) == 0) {
#     setwd("results")
# }

res.raw <- readRDS("results/results_2022-21-01-22:38:03")
res <- res.raw$data

# Table of median values
pkg <- as.vector(unlist(unique(res["pkg"]), use.names=FALSE))
nodes <- strtoi(as.vector(unlist(unique(res["nodes"]), use.names=FALSE)))
nw.type <- sort(as.vector(unlist(unique(res["nw.type"]), use.names=FALSE)))
classifier <- sort(as.vector(unlist(unique(res["classifier"]), use.names=FALSE)))
metrics <- c("AUC", "PR.AUC", "BCR", "norm_MCC")

# Create resulting list
li <- list()
# huge
li$huge$nodes <- matrix(0, ncol=4, nrow=4)
colnames(li$huge$nodes) <- nodes
rownames(li$huge$nodes) <- metrics
li$huge$nw.type <- matrix(0, ncol=4, nrow=4)
colnames(li$huge$nw.type) <- nw.type
rownames(li$huge$nw.type) <- metrics
li$huge$classifier <- matrix(0, ncol=6, nrow=4)
colnames(li$huge$classifier) <- classifier
rownames(li$huge$classifier) <- metrics

# mcgraph
li$mcgraph$nodes <- matrix(0, ncol=4, nrow=4)
colnames(li$mcgraph$nodes) <- nodes
rownames(li$mcgraph$nodes) <- metrics
li$mcgraph$nw.type <- matrix(0, ncol=4, nrow=4)
colnames(li$mcgraph$nw.type) <- nw.type
rownames(li$mcgraph$nw.type) <- metrics
li$mcgraph$classifier <- matrix(0, ncol=6, nrow=4)
colnames(li$mcgraph$classifier) <- classifier
rownames(li$mcgraph$classifier) <- metrics


for (mt in metrics) {
    for (pk in pkg) {
        for (nd in nodes) {
            if (pk == "huge") {
                li$huge$nodes[[which(metrics == mt), which(nodes == nd)]] <- round(median(res[which(res["pkg"] == pk & res["nodes"] == nd), which(colnames(res) == mt)]), 3)
            } else if (pk == "mcgraph") {
                li$mcgraph$nodes[[which(metrics == mt), which(nodes == nd)]] <- round(median(res[which(res["pkg"] == pk & res["nodes"] == nd), which(colnames(res) == mt)]), 3)
            }
        }
        for (nw in nw.type) {
            if (pk == "huge") {
                li$huge$nw.type[[which(metrics == mt), which(nw.type == nw)]] <- round(median(res[which(res["pkg"] == pk & res["nw.type"] == nw), which(colnames(res) == mt)]), 3)
            } else if (pk == "mcgraph") {
                li$mcgraph$nw.type[[which(metrics == mt), which(nw.type == nw)]] <- round(median(res[which(res["pkg"] == pk & res["nw.type"] == nw), which(colnames(res) == mt)]), 3)
            }
        }
        for (cls in classifier) {
            if (pk == "huge") {
                li$huge$classifier[[which(metrics == mt), which(classifier == cls)]] <- round(median(res[which(res["pkg"] == pk & res["classifier"] == cls), which(colnames(res) == mt)]), 3)
            } else if (pk == "mcgraph") {
                li$mcgraph$classifier[[which(metrics == mt), which(classifier == cls)]] <- round(median(res[which(res["pkg"] == pk & res["classifier"] == cls), which(colnames(res) == mt)]), 3)
            }
        }
    }
}

for (nm in names(li$huge)) {
    write.csv(li$huge[nm], paste0("results/", "median_", "huge_", nm, ".csv"))
}
for (nm in names(li$mcgraph)) {
    write.csv(li$mcgraph[nm], paste0("results/", "median_", "mcgraph_", nm, ".csv"))
}

# if (length(grep(x=getwd(), pattern="results")) == 1) {
#     setwd("..")
# }