# Description:
# This function is wrapper for the 'huge' estimator functions. The estimators of 'huge' automatically regularization parameters called lambdas.
# Because the function to calculate the metrics 'mcg.roc' of 'mcgraph' needs thresholds, an estimate is done beforehand.
# For this to work, a function is needed to extract the paths, i.e. the predictions of 'huge' based on the lambda values.
# Thus 'd' in this case is not the data matrix, but the huge output, i.e. a list.
# Arguments:
# d : The output list of the huge function.
# thr : The lambda values of the huge output.
# ... : Additional arguments of the huge function.

huge.wrapper <- function(d, thr, ...) {
    # Note: It might be, that some lambdas occur multiple times. Thus, we have to guarantee, that only one path is chosen.
    idx <- which(d$lambda == thr)[1]
    return(as.matrix(d$path[[idx]]))
}
