% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{degree.mcgraph}
\alias{degree.mcgraph}
\title{degree of the vertices}
\usage{
\method{degree}{mcgraph}(x, mode = "all", ...)
}
\arguments{
\item{x}{The mcgraph object to analyze.}

\item{mode}{Character string. Ignored if the graph is undirected. For directed graphs "out" will give the outgoing edges, "in" will give the incoming edges and "all" will give the sum of in- and outgoing edges.}

\item{\dots}{Currently not used.}
}
\value{
Named vector with the degree for each edge.
}
\description{
The degree of the vertex is the number of edges connecting the vertex to other vertices.
}
\details{
The degree of a vertex represents a fundamental property of a vertex. Vertices with degree 0 are unconnected to other vertices. The degree of a vertex is an important centrality measure.
}
\examples{
ang=mcg.angie(nodes=12,edges=16)
anu=mcg.u2d(ang,input='A1')
degree(ang)
degree(anu)
degree(anu,mode="in")
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>
}
