% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.components}
\alias{mcg.components}
\alias{mcg.shortest.paths}
\title{Get component ids from adjacency matrices or mcgraph objects}
\usage{
mcg.components(A, P = NULL)

mcg.shortest.paths(A, mode = "directed", code = "C++")
}
\arguments{
\item{A}{mcgraph object or adjacency matrix}

\item{P}{Matrix with the length of the shortest paths between each node.}

\item{mode}{should graph be taken as directed graphs, or undirected, if mode='undirected' is given, the graph is transformed into an undirected graph, if mode is 'directed' no graph transformation is done, default: 'directed'}

\item{code}{should the R or the C++ version be used, default: C++}
}
\value{
vector with component ids and node names labeling the ids.

matrix of same dimension as input matrix with vector with component ids and node names labeling the ids.
}
\description{
Checks the components of the given adjacency matrix or the given mcgraph objects and returns a unique numerical id for each components.

Returns the shortes paths between each pair of nodes or Inf if they belong
    to different graph components which are not connected. Attention this only works for undirected graphs and directed graphs are converted internally to undirected graphs. For a full and faster implemention use more sophisticated R packages, like igraph. The method is mainly used for  the layout mechanism.
}
\examples{
cls=mcg.cluster(nodes=12,edges=15,cluster=3)
class(cls)
plot(cls,layout='sam')
mcg.components(cls)
cls <- mcg.cluster(nodes=12, edges=14, cluster=3)
class(cls)
plot(cls, layout='sam')
mcg.shortest.paths(cls, code="R")
mcg.shortest.paths(cls, code="C++")
ang <- mcg.angie(node=36, edges=48)
t1 <- Sys.time()
mcg.shortest.paths(cls, code="R");
print(Sys.time() - t1)
t1 <- Sys.time()
mcg.shortest.paths(cls, code="C++")
print(Sys.time() - t1)
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>

Detlef Groth <email: dgroth@uni-potsdam.de>, Masiar Novine <email: masiar.novine@gmail.com>
}
