% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.corrplot}
\alias{mcg.corrplot}
\title{mcg.corrplot simple display of correlation matrices}
\usage{
mcg.corrplot(
  mt,
  text.lower = FALSE,
  text.upper = FALSE,
  pch.minus = 19,
  pch.plus = 19,
  xtext = NULL,
  cex = 1,
  cex.names = 1,
  cex.coeff = 1,
  ...
)
}
\arguments{
\item{mt}{correlation matrix or any other numeric matrix as input. Values must be in the range of -1, 1.}

\item{text.lower}{should the coefficients be plottet in the lower plot triangle. Default: FALSE}

\item{text.upper}{should the coefficients be plottet in the upper plot triangle. Default: FALSE}

\item{pch.minus}{plotting character for negative correlations, a good possibility is 18. Default: 19}

\item{pch.plus}{plotting character for positive correlations. Default: 19}

\item{xtext}{text added at the bottom of the plot below of the last value line.}

\item{cex}{relative size of the plotting symbols on the plot. Default: 1}

\item{cex.names}{enlargment value for row and column names. Default: 1}

\item{cex.coeff}{enlargement coefficient for the r coefficients. Default: 1}

\item{\dots}{Any other argument will be passed to the generic plot function.}
}
\value{
nothing.
}
\description{
`mcg.corrplot` provides a simple display of correlation matrices using filled circles to represent the strength of correlation.
}
\details{
This is a small plot utility to display correlation matrices and other matrices with numeric values in the range of -1, 1.
}
\examples{
\dontrun{
if(interactive()){
 ang=mcg.angie(nodes=12,edges=15)
 anu=mcg.u2d(ang)
 and=mcg.graph2data(anu)
 mcg.corrplot(cor(t(and)),text.lower=TRUE)
 pca=prcomp(scale(t(and))
 mcg.corrplot(pca$rotation)
 }
}
}
