% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.ct}
\alias{mcg.ct}
\title{mcg.ct - create new graphs from correlation matrix or from raw data}
\usage{
mcg.ct(x, type = "ct", rs = 0.04, is.squared = FALSE, method = "pearson")
}
\arguments{
\item{x, }{either a symmetrix correlation matrix or a data fram or matrix with raw data,}

\item{type}{custom type name for the graph, Default: 'ct'}

\item{rs}{threshold for the R-square value. Default: 0.04}

\item{is.squared}{is the matrix already squared, if not the function will scale the matrix before applying the threshold.}

\item{method}{for raw data which method for measuring correlation stringth should be used, default: 'pearson'}
}
\value{
an mcgraph object for the given data or correlation  matrix.
}
\description{
mcg.ct - creates a new mcgraph object from a given correlation matrix or using raw data using a simple R-square thresholding mechanism
}
\details{
The function mcg.ct generates for the given correlation matrix a mcgraph object. Any two nodes, which are representated by row/column names will be connected in the undirected graph
       if their R-square value exceeds the given threshold,
       edges between nodes which are negatively assiciated will get value of -1 in the adjacency matrix,
       edges which connect nodes which are positively correlated will get
       a value of 1 in the adjacency matrix.
}
\examples{
 G=matrix(0,nrow=6,ncol=6)
 rownames(G)=colnames(G)=LETTERS[1:6]
 G['A','C']=1
 G['B','C']=1
 G['C','D']=1
 G['D','E']=1
 G['D','F']=1
 G['E','F']=1
 G=mcg.new(G,type="test")
 G.data=mcg.graph2data(G,n=200)
 G2=mcg.ct(cor(t(G.data)))
 par(mfrow=c(1,2))
 plot(G,main="Real Graph",layout='sam')
 plot(G2,main="Predicted Graph",layout='sam')
 data(swiss)
 plot(mcg.ct(swiss,method="spearman",rs=0.1),layout="star")
}
