% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.layout.frg}
\alias{mcg.layout.frg}
\title{Force-directed layouts for graphs}
\usage{
mcg.layout.frg(
  A,
  iter = 500,
  W = 10,
  L = 10,
  temp_prop = 0.2,
  force_prop = 1.5,
  quench_prop = 0.9,
  simmering_prop = 0.05,
  seed = 1234
)
}
\arguments{
\item{A}{Adjacency matrix.}

\item{iter}{Number of refinement iterations. Default: 500}

\item{W}{Width of the frame. Default: 10}

\item{L}{Length of the frame. Default: 10}

\item{temp_prop}{Proportion of the width of the frame used as temperature. Default: 0.2}

\item{force_prop}{Factor influencing the strength of repulsion and attraction. Higher values tend to seperate nodes more. Default: 1.5}

\item{quench_prop}{Initial proportion used as the basis in the cooling function. See 'Details' for more information. Default: 0.9}

\item{simmering_prop}{Proportion of the inital temperature used for simmering. Default: 0.05}

\item{seed}{Initial seed, can also be set to \code{NULL}. Default: 1234}
}
\value{
Position matrix with two columns for 'x' and 'y' coordinates.
}
\description{
Generating graph layouts based on the Fruchterman-Reingold algorithm.
}
\details{
The area of the frame is given by \code{W} * \code{L}, while the temperature t is given by \code{temp_prop} * \code{W}.
         If there is too much space between components of a graph, e.g. for small cluster networks, it can be useful to decrease the area
         by setting lower values for \code{W} and {L}, e.g. \code{W = 4} and {L = 4}.

         Cooling is based on quenching and simmering as described in the original publication (see 'References'),
         i.e. rapid cooling of the temperature and then staying at a low constant temperature level to allow for minor optimizations.
         The lower constant is given by the initial temperature mulitplied by \code{simmering_prop}.
         Cooling is based on the following function:
             t[i] = t[i-1] * \code{quench_prop}^i
         where t[i] and t[i-1] are the temperature values at iteration i and i-1, respectively.
         The default values aim to give good layouts for different kind of graphs.

         The constant 'k' described in the original publication
         can be influenced by \code{force_prop}, explicitly:
             k = \code{force_prop} * sqrt(area / n)
         where n is the number of nodes of the graph.
         Hence, by setting higher values for \code{force_prop} the repulsion of the nodes will be increased. For very high values (>> 100) the
         layout will converge to a circle layout.

         The default number of iterations for refinement given by \code{iter} should be sufficient for most graphs to reach a global optimum.
         Sometimes, changing the \code{seed} can improve the overall layout.

         The FRG algorithm is especially useful for symmetric graphs, such as graphs representing geometric objects,
         e.g. cubes, prisms etc. (see 'Examples').
}
\examples{
ang <- mcg.angie(nodes=25, edges=60)

# Save layout for reuse, precalculate layout
xy <- mcg.layout(ang, mode='frg')
plot(ang, layout=xy, label.size=.7, vertex.size=.5)

# Cluster example, layout created by plot function
C <- mcg.cluster(nodes=18, edges=24)
plot(C, layout="frg")

# Cube example
cube <- matrix(c(0,1,0,1,0,0,1,0,
                 1,0,1,0,0,0,0,1,
                 0,1,0,1,0,1,0,0,
                 1,0,1,0,1,0,0,0,
                 0,0,0,1,0,1,1,0,
                 0,0,1,0,1,0,0,1,
                 1,0,0,0,1,0,0,1,
                 0,1,0,0,0,1,1,0), nrow=8, ncol=8)
cube <- mcg.new(cube)
rownames(cube) <- colnames(cube) <- mcg.autonames(LETTERS, nrow(cube))
plot(cube, layout="frg")

# Pentagonal prism
penta <- matrix(c(0,1,1,0,0,0,0,0,1,0,
                  1,0,0,1,0,0,0,0,0,1,
                  1,0,0,1,1,0,0,0,0,0,
                  0,1,1,0,0,1,0,0,0,0,
                  0,0,1,0,0,1,1,0,0,0,
                  0,0,0,1,1,0,0,1,0,0,
                  0,0,0,0,1,0,0,1,1,0,
                  0,0,0,0,0,1,1,0,0,1,
                  1,0,0,0,0,0,1,0,0,1,
                  0,1,0,0,0,0,0,1,1,0), ncol=10, nrow=10)
penta <- mcg.new(penta)
rownames(penta) <- colnames(penta) <- mcg.autonames(LETTERS, nrow(penta))
plot(penta, layout="frg")
}
\references{
Fruchterman, T.M.J and Reingold, E.M., (1991), Graph Drawing by Force-directed Placement, Software–Practice and Experience, pp.1129-1164.
}
\author{
Masiar Novine <email: masiar.novine@gmail.com>, Detlef Groth <email: dgroth@uni-potsdam.de>
}
