% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.constellation}
\alias{mcg.constellation}
\title{Example networks based on start sign constellations}
\usage{
mcg.constellation(name = "lion")
}
\arguments{
\item{name}{the name of the constellation, i. e. 'Lion', Dipper' or 'Virgin'. Default: 'Lion'}
}
\value{
graph of class mcgraph with adjacency matrix for an undirected graph
}
\description{
`mcg.constellation` creates graphs, mimicking selected start sign constellations.
}
\details{
This graph generation function generates graphs which
         mimick constellations on the northern sky, e. g. 'Lion',
         'Dipper' and 'Virgin'. There will be a few default input nodes given.
}
\examples{
lion <- mcg.constellation(name='lion')
# Plot with adjusted vertex, edge and label size for nicer look
plot(lion, main="Lion", label.size=0.7, vertex.size=0.8)
}
\author{
Masiar Novine <email: masiar.novine@gmail.com>
}
