% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.lvs}
\alias{mcg.lvs}
\title{mcg.lvs - greedy forward variable selection in linear models for network reconstruction}
\usage{
mcg.lvs(
  d,
  rs = 0.04,
  k = 5,
  output = "mcgraph",
  code = "C++",
  method = "pearson"
)
}
\arguments{
\item{d}{Data frame or matrix with rows including data values and variables in columns. Using only numbers as column names is not allowed.}

\item{rs}{Threshold for the R-square value. Default: 0.02}

\item{k}{Maximal number of correlated variables to consider. Default: 5}

\item{output}{Returned data type, either a mcgraph object, a matrix (adjacency matrix) or a list (adjacency list). Default: 'mcgraph'}

\item{code}{Should the R or the C++ version be used? Default: 'C++'}

\item{method}{Method used to calculate the values of the correlation matrix. Default: 'pearson'}
}
\value{
A `mcgraph` matrix object, alternatively a matrix or a list depending on the value of the argument 'output'.
}
\description{
'mcg.lvs' uses a simple greedy approach to build a linear model for network reconstruction.
             For each variable, higher correlated variables are checked and included in the model by
             thresholding: A higher correlated variable is included in the model, if
             (1) Aikes Information Crition (AIC) becomes smaller and (2) the difference of the
             Pearson coefficient of determination (R-square value) becomes larger compared to not including the variable.
             The result is either an adjacency matrix for an undirected graph, an 'mcgraph' object or a list with
             all chosen covariates for each variable of the model.

             \code{NA} entries are internally dealt with by just removing the according rows. Hence, possible imputation should
             be performed beforehand.
}
\examples{
data(swiss)

Gswiss <- mcg.lvs(swiss, rs=0.1, output='mcgraph')
plot(Gswiss, main="Predicted Graph", layout='frg')
plot(Gswiss, main="Predicted Graph", layout='star')

# Compare run time of R vs C++ implementation
ang <- mcg.angie(nodes=26, edges=40)
data <- mcg.graph2data(ang)
plot(ang, layout="frg")
}
\author{
: Masiar Novine <email: masiar.novine@gmail.com>
}
