# Description:
# Wrapper for Monte Carlo data generation function mcg.graph2data
# Arguments:
# n : Number of random samples generated per node
# nodes : Number of nodes of the graph
# graph : The graph type given by the name of the specific function, e.g. "mcg.cluster", "mcg.barabasi", "mcg.hubs", "mcg.random".
#         Note that "mcg.barabasi" generates "scale-free" graphs, as also called by the huge package.
# seed : An initial seed given as an integer value.
# iter : Number of iterations for Monte Carlo sampling.
# val : Mean value of the normal distribution, from which the random samples are drawn from.
# sd : Standard deviation of the normal distribution, the random values are drawn from.
# prop : The proportion of the value of the source, which is used for calculating the updated value of the target in each iteration.
# code : The programming language of the implementation, either "C++" for C++ code or "R" for R code. The latter being much slower
#        and only kept to be able to simply investigate the code.
# ... : Additional arguments for the individual graph functions.

mcg.g2d.wrapper <- function(n=200, nodes, graph, seed, iter=30, val=100, sd=2, prop=0.05, noise=1, code="C++", ...) {
    set.seed(seed)
    fun <- match.fun(graph)
    G <- forceAndCall(1, fun, nodes, ...)
    set.seed(seed)
    # Fast C++ implementation
    d <- mcg.graph2data(G, n=n, iter=iter, val=val, sd=sd, prop=prop, noise=noise, code=code)
    # Transpose matrix of d
    return(list(theta=G, data=t(d)))
}