require(mcgraph)

# EXAMPLES OF NETWORK TYPES

# angie
set.seed(1234)
ang=mcg.angie(nodes=12,edges=18)
ang_lay <- matrix(c(
             0.3988633,  0.56816778,
            -0.1541770,  0.35732874,
            -0.7535419,  0.71823217,
            -0.3920881, -0.24690009,
             0.6345397,  0.08337367,
             0.4094549, -0.70278669,
            -0.6086931,  0.31928349,
            -1.0067733,  0.02570682,
             0.6179075,  1.03708555,
             0.2369357, -0.29413711,
             0.5193059, -1.19578183,
            -0.8715300, -0.70031311),
             ncol=2, byrow=TRUE)
rownames(ang_lay) <- rownames(ang)

# hub
hub=mcg.hubs(nodes=12,hubs=2)
hub_lay <- mcg.layout(hub, mode="frg", iter=500, force_prop=0.9)

# barabasi
bar=mcg.barabasi(nodes=12,m=2)
bar_lay <- mcg.layout(bar, mode="frg", quench_prop=0.85, force_prop=1.5)

# cluster
set.seed(1234)
clu=mcg.cluster(nodes=12,cluster=2,edges=15)
clu_lay <- matrix(c(
              1.55692288,  0.53991321,
              0.80070964,  0.80765800,
              1.02669820,  1.21511286,
              1.25667517,  0.09874163,
              0.49647352,  0.12816840,
              0.17067282,  0.61409651,
              0.65617975, -0.87950839,
              0.42620278, -0.33749893,
             -0.04652765, -0.90130862,
             -0.62147007, -0.51421293,
             -0.19464212, -0.09276731,
             -1.16511817, -0.57049785),
             ncol=2, byrow=TRUE)
rownames(clu_lay) <- rownames(clu)

set.seed(1234)
pdf("../figure/Figure3.pdf", width=5, height=5)
par(mfrow=c(2, 2), mar=c(1,0,1.5,0), pty="s")
ti <- c("random", "hub", "scale-free", "cluster")
g <- c("ang", "hub", "bar", "clu")
lay <- c("ang_lay", "hub_lay", "bar_lay", "clu_lay")
for (i in seq_along(g)) {
  plot(eval(str2lang(g[i])), layout=eval(str2lang(lay[i])), main=ti[i], cex.main=1.1, vertex.border.color="black",
            label.color="black", edge.color="black", edge.width=1.2, vertex.size=1.4, label.size=0.7, show.labels=TRUE)
            #box()
}
dev.off()