% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.graph}
\alias{mcg.graph}
\title{mcg.graph create random graphs and data for those graphs}
\usage{
mcg.graph(U, n = 200, input = 2)
}
\arguments{
\item{U}{adjacency matrix for an undirected graph.}

\item{n}{number of observations to generate for the created directed graph type type of graph.}

\item{input}{number of random input nodes, if node labels are given they are taken as input nodes.}
}
\value{
An mcgraph graph object with list item data (simulated data for the directed graph).
}
\description{
`mcg.graph` creates random directed graphs and simulated data for them from undirected graphs, or just data for directed graphs.
}
\section{Details}{


This function allows you to create random graphs, either directed or undirected and data belonging
to the actual graph structure based on Monte Carlo simulations. If the graph is already directed just the data are generated for this graph.
}

\examples{
band=mcg.band(16)
mcb=mcg.graph(band,n=200,input='A1')
plot(mcb,layout='circle')
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>
}
\keyword{Carlo}
\keyword{Monte}
\keyword{sampling}
