% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.lattice}
\alias{mcg.lattice}
\title{mcg.lattice creates a lattice like graph}
\usage{
mcg.lattice(dim = 5, centralize = 0)
}
\arguments{
\item{dim}{dimensions of the lattice matrix, i.e. number of rows and columns}

\item{centralize}{Level of centralization, 0 no default no edges are added, 1 four edges are added to each corner edge and so on.}
}
\value{
Graph of class mcgraph with adjacency matrix for an undirected graph.
}
\description{
`mcg.lattice` creates a lattice graph of size `dim x dim` with some optional centralizing edges.
}
\details{
This function create a lattice graph of size `dim x dim`. Additionally some centralizing edges can be added connecting the angular outer nodes more to the center. The parameter `centralize = 1` will add four edges to all four corner nodes, `centralize = 2` will add eight edges.
}
\examples{
lat=mcg.lattice(7,centralize=2)
plot(lat,layout='grid')
}
\author{
Detlef Groth <dgroth@uni-potsdam.de>
}
