% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.u2d}
\alias{mcg.u2d}
\title{mcg.u2d converts an undirected to a directed graph}
\usage{
mcg.u2d(A, input = 2, negative = 0)
}
\arguments{
\item{A}{undirected input graph}

\item{input}{number of input nodes in the graph, if number of inout nodes is smaller than number of components, for each component one inout node is automatically created.}

\item{negative}{proportion of inhibitive associations in the network value between 0 and 1 are acceptable, Default 0.0}
}
\value{
directed graph
}
\description{
`mcg.u2d` gets an undirected input graph and returns a directed graph based on 1 or more input nodes.
}
\details{
This function creates a directed graph from an undirected one by the given input nodes. Input nodes can be chosen by names or a number for random selection of input nodes will be given.
Input nodes will have at least shortest path distance to other input nodes of pathlength two.
Selected input nodes will draw in each iteration outgoing edges to other nodes in the nth iteration neighborhood. The input
nodes will alternatively select the next edges on the path to not visited nodes. All edges will be only visited onces.
}
\examples{
cross=mcg.cross(bands=5,length=5)
D=mcg.u2d(cross,input=3)
plot(D)
angie=mcg.angie(nodes=8,edges=12)
and=mcg.u2d(angie,input=2,negative=0.2)
plot(and,layout="sam")
hubs=mcg.hubs(nodes=18,hubs=3)
plot(mcg.u2d(hubs,input=4),layout="sam")
}
\author{
: Detlef Groth <dgroth@uni-potsdam.de>
}
